<div id="wpsc_product_wholesale_pricing">
	<p class="description"><?php _e( 'Enable a User Role to override default pricing for that User Role.', 'wpsc_wp' ); ?></p>
	<table class="widefat fixed">
		<thead>

			<tr>
				<th class="manage-column column-cb check-column">&nbsp;</th>
				<th class="manage-column"><?php _e( 'Role', 'wpsc_wp' ); ?></th>
				<th class="manage-column"><?php _e( 'Markup', 'wpsc_wp' ); ?></th>
				<th class="manage-column"><?php _e( 'Fixed Price', 'wpsc_wp' ); ?></th>
				<th class="manage-column"><?php _e( 'Product Visibility', 'wpsc_wp' ); ?></th>
			</tr>

		</thead>
		<tbody>

<?php
foreach( $editable_roles as $key => $role ) {
	$name = translate_user_role( $role['name'] ); ?>
			<tr id="role_<?php echo $key; ?>">
				<th scope="row" class="check-column">
					<input type="checkbox" id="wpsc_wp_checkbox_<?php echo $key; ?>" name="meta[_wpsc_product_metadata][wpsc_wp_checkbox][<?php echo $key; ?>]"<?php if ( isset( $checkbox[$key] ) ) checked( $checkbox[$key], 'on' ); ?> />
				</th>
				<td scope="row" style="padding-top:0.8em;">
					<label for="wpsc_wp_checkbox_<?php echo $key; ?>"><strong><?php echo $name; ?></strong></label>
				</td>
				<td scope="row">
					<select id="wpsc_wp_value_<?php echo $key; ?>" name="meta[_wpsc_product_metadata][wpsc_wp_value][<?php echo $key; ?>]">
<?php
	switch( $value[$key] ) {

		case '+':
		default:
			$output = '<option value="+" selected="selected">+&nbsp;</option>';
			$output .= '<option value="-">-&nbsp;</option>';
			break;

		case '-':
			$output = '<option value="+">+&nbsp;</option>';
			$output .= '<option value="-" selected="selected">-&nbsp;</option>';
			break;

	}
	echo $output;
	unset( $output ); ?>
					</select>
					<input type="text" id="wpsc_wp_amount_<?php echo $key; ?>" name="meta[_wpsc_product_metadata][wpsc_wp_amount][<?php echo $key; ?>]" class="text" size="5" value="<?php echo $amount[$key]; ?>" />
					<select id="wpsc_wp_method_<?php echo $key; ?>" name="meta[_wpsc_product_metadata][wpsc_wp_method][<?php echo $key; ?>]">
<?php
	switch( $method[$key] ) {

		case '$':
			$output = '<option value="%">%&nbsp;</option>';
			$output .= '<option value="$" selected="selected">$&nbsp;</option>';
			break;

		default:
		case '%':
			$output = '<option value="%" selected="selected">%&nbsp;</option>';
			$output .= '<option value="$">$&nbsp;</option>';
			break;

	}
	echo $output;
	unset( $output ); ?>
					</select>
				</td>
				<td>
					<input type="text" id="wpsc_wp_fixed_<?php echo $key; ?>" name="meta[_wpsc_product_metadata][wpsc_wp_fixed][<?php echo $key; ?>]" class="text" size="5" value="<?php echo wpsc_currency_display( $fixed[$key], $currency_args ); ?>" />
				</td>
				<td>
					<select id="wpsc_wp_visibility_<?php echo $key; ?>" name="meta[_wpsc_product_metadata][wpsc_wp_visibility][<?php echo $key; ?>]">
<?php
	switch( $visibility[$key] ) {

		default:
		case '1':
			$output = '<option value="1" selected="selected">' . __( 'Show Product', 'wpsc_wp' ) .'&nbsp;</option>';
			$output .= '<option value="0">' . __( 'Hide Product', 'wpsc_wp' ) . '&nbsp;</option>';
			break;

		case '0':
			$output = '<option value="1">' . __( 'Show Product', 'wpsc_wp' ) .'&nbsp;</option>';
			$output .= '<option value="0" selected="selected">' . __( 'Hide Product', 'wpsc_wp' ) . '&nbsp;</option>';
			break;

	}
	echo $output;
	unset( $output ); ?>
					</select>
				</td>
			</tr>

<?php
} ?>
		</tbody>
	</table>

	<table>
		<tr>
			<td style="font-size:11px;"><br />
<?php
if( $post->post_parent == 0 ) { // Only display if not a variation
	switch( $disregard_product ) {
	
		case 'on': ?>
				<label><input type="radio" id="wpsc_wp_disregard_off" name="meta[_wpsc_product_metadata][wpsc_wp_disregard]" value="off" /> <?php _e( 'Enable Wholesale Pricing for this Product', 'wpsc_wp' ); ?></label><br />
				<label><input type="radio" id="wpsc_wp_disregard_on" name="meta[_wpsc_product_metadata][wpsc_wp_disregard]" value="on" checked /> <?php _e( 'Disable Wholesale Pricing for this Product', 'wpsc_wp' ); ?></label>
	<?php
			break;

		default:
		case 'off': ?>
				<label><input type="radio" id="wpsc_wp_disregard_off" name="meta[_wpsc_product_metadata][wpsc_wp_disregard]" value="off" checked /> <?php _e( 'Enable Wholesale Pricing for this Product', 'wpsc_wp' ); ?></label><br />
				<label><input type="radio" id="wpsc_wp_disregard_on" name="meta[_wpsc_product_metadata][wpsc_wp_disregard]" value="on" /> <?php _e( 'Disable Wholesale Pricing for this Product', 'wpsc_wp' ); ?></label>
	<?php
			break;
	
	}
} else { ?>
				<p><?php _e( 'Variation price controls override the parent price controls', 'wpsc_wp' ); ?></p>
<?php } ?>
			</td>
		</tr>
	</table>
</div>
<!-- #wpsc_product_wholesale_pricing -->